/*+ TsipParser.h
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2005 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file defines the CTsipParser class.
 *            
 * Revision History:
 *    05-18-2005    Mike Priven
 *                  Written
 *
 * Notes:
 *
-*/

#ifndef TSIP_PARSER_H
#define TSIP_PARSER_H

/*---------------------------------------------------------------------------*\
 |                         I N C L U D E   F I L E S
\*---------------------------------------------------------------------------*/
#include "ParserDefinitions.h"


/*---------------------------------------------------------------------------*\
 |                  C O N S T A N T S   A N D   M A C R O S
\*---------------------------------------------------------------------------*/
#define MSG_IN_COMPLETE  0
#define TSIP_DLE         1
#define TSIP_IN_PARTIAL  2

#define DLE              0x10 // TSIP packet start/end header         
#define ETX              0x03 // TSIP data packet tail                
#define MAX_TSIP_PKT_LEN 300  // max length of a TSIP packet 

#define MAX_SC_MESSAGE   13
#define MAX_EC_MESSAGE   6
#define MAX_AS1_MESSAGE  4

#define INFO_DGPS        0x02
#define INFO_2D          0x04
#define INFO_FILTERED    0x10


/*---------------------------------------------------------------------------*\
 |             F O R W A R D   C L A S S   D E C L A R A T I O N S
\*---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------*\
 |                      C L A S S   D E F I N I T I O N
\*---------------------------------------------------------------------------*/
class CTsipParser
{

public: //==== P U B L I C   M E T H O D S ===================================/

    CTsipParser() {};
    ~CTsipParser() {};

	bool    IsStartOfTsip(U8 ucByte);
	void    Reset(); 
    int     ReceiveByte (U8 ucByte, unsigned char ucPkt[], int *pPktLen);
    CString ParsePkt   (unsigned char ucPkt[], int nPktLen);


private: //==== P R I V A T E   M E T H O D S ================================/

    void Parse0x41   (unsigned char ucData[], int nLen);
    void Parse0x42   (unsigned char ucData[], int nLen);
    void Parse0x43   (unsigned char ucData[], int nLen);
    void Parse0x45   (unsigned char ucData[], int nLen);
    void Parse0x46   (unsigned char ucData[], int nLen);
    void Parse0x4A   (unsigned char ucData[], int nLen);
    void Parse0x4B   (unsigned char ucData[], int nLen);
    void Parse0x55   (unsigned char ucData[], int nLen);
    void Parse0x56   (unsigned char ucData[], int nLen);
    void Parse0x6D   (unsigned char ucData[], int nLen);
    void Parse0x82   (unsigned char ucData[], int nLen);
    void Parse0x83   (unsigned char ucData[], int nLen);
    void Parse0x84   (unsigned char ucData[], int nLen);
    void Parse0x8F   (unsigned char ucData[], int nLen);
    void Parse0x8F20 (unsigned char ucData[], int nLen);
    void Parse0x8FAB (unsigned char ucData[], int nLen);
    void Parse0x8FAC (unsigned char ucData[], int nLen);

    void Parse0x4ALong  (unsigned char ucData[], int nLen);
    void Parse0x4AShort (unsigned char ucData[], int nLen);

    S16  GetShort    (U8* pucBuf);
    U16  GetUShort   (U8* pucBuf);
    S32  GetLong     (U8* pucBuf);
    U32  GetULong    (U8* pucBuf);
    FLT  GetSingle   (U8* pucBuf);
    DBL  GetDouble   (U8* pucBuf);

    CString ShowTime (FLT fltTimeOfWeek);


private: //==== P R I V A T E   M E M B E R   V A R I A B L E S ==============/

    CString m_str, m_strTemp;
	int m_nParseState; 

};

#endif
